package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.db.DocumentTemplateDAO;

public class DocumentTemplateDAOMock implements DocumentTemplateDAO {

	private static final HashMap<Integer,DocumentTemplate> IDHash = new HashMap<Integer,DocumentTemplate>();
	private static boolean initialized = false;
	
	@Override
	public DocumentTemplate findById(int documentTemplateId)
			throws ObjectNotFoundException {
		initializeDocumentTemplateHash();

		DocumentTemplate result = IDHash.get(documentTemplateId);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}
		
		return result;
	}

	@Override
	public List<DocumentTemplate> listAll() {
		List<DocumentTemplate> result = new ArrayList<DocumentTemplate>();
		
		initializeDocumentTemplateHash();
		
		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;
	}

	private void createDocumentTemplate(final int id, final String name, final int sortOrder) {
		DocumentTemplate dt = new DocumentTemplate();
		dt.setId(id);
		dt.setName(name);
		dt.setActivityType("R");
		dt.setSortOrder(sortOrder);
		IDHash.put(dt.getId(), dt);
	}
	
	private void initializeDocumentTemplateHash() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;
		
		createDocumentTemplate(4, "Research Request Memo", 9);
		createDocumentTemplate(5, "Research Study Institutional Review Board (IRB) Approval Letter", 12);
		createDocumentTemplate(6, "CDW-VINCI Rules of Behavior", 13);
		createDocumentTemplate(7, "Sample Informed Consent and HIPAA Authorization", 14);
		createDocumentTemplate(8, "VA Privacy Statement", 15);
		createDocumentTemplate(9, "Research and Development (RD) Committee Approval Letter", 71);
		createDocumentTemplate(10, "VA Form 9957", 72);
		createDocumentTemplate(11, "DSS Non-Disclosure Agreement", 77);
		createDocumentTemplate(12, "Data Use Agreement", 79);
		createDocumentTemplate(13, "IRB Approval of Waiver of HIPAA-Compliant Authorization", 102);
		createDocumentTemplate(14, "PI must submit the CDW ROB", 103);
		createDocumentTemplate(15, "PI must submit the VA Privacy Statement", 104);
		createDocumentTemplate(16, "Vital Status Rules of Behavior", 106);
		createDocumentTemplate(17, "GEC (Geriatrics and Extended Care) Data Use Agreement (DUA)", 108);
		createDocumentTemplate(18, "Research Protocol", 109);
		createDocumentTemplate(19, "CDW-Domain Checklist", 149);
		createDocumentTemplate(20, "VSSCS Data Use Agreement", 155);
		createDocumentTemplate(21, "NDS Data Use Agreement", 162);
		createDocumentTemplate(22, "CDW Rules of Behavior", 163);
		createDocumentTemplate(23, "ORD 9957", 164);
		createDocumentTemplate(24, "Research Privacy Review Checklist", 165);
		createDocumentTemplate(25, "VSSC OEF/OIF Roster File DUA", 176);
		createDocumentTemplate(26, "VHA Privacy Data Access Agreement", 177);
		createDocumentTemplate(27, "VHA Privacy DAA", 178);
		createDocumentTemplate(28, "Project Information and Authorization", 179);
		createDocumentTemplate(29, "Agreement To Provide Secure Data Storage At Terminal", 180);
		createDocumentTemplate(30, "Data Security Compliance Checklist", 181);
		createDocumentTemplate(31, "IRB Continuing Review Approval Letter", 182);
		createDocumentTemplate(32, "Data Description", 183);
		createDocumentTemplate(33, "VA/CMS Rules of Behavior", 184);
		createDocumentTemplate(34, "VIReC Data Use Agreement", 185);
		createDocumentTemplate(35, "DAC Review Checklist", 186);
		createDocumentTemplate(36, "Completeness Review Checklist", 187);
		createDocumentTemplate(37, "TD Initial Review Checklist", 188);
		createDocumentTemplate(38, "TD Initial Release Checklist", 189);
		createDocumentTemplate(39, "Internal Document Review Checklist", 190);
		createDocumentTemplate(40, "Signed VIReC DUA", 191);
		createDocumentTemplate(41, "Data Transfer for Temporary Storage (Required)", 192);
		createDocumentTemplate(42, "OEF-OIF Data Use Agreement", 155);
		createDocumentTemplate(43, "EHR Access Request Form", 200);
		createDocumentTemplate(44, "CDW Justification Memo", 1);
		createDocumentTemplate(45, "VHA NDS Health Operations", 1);
		
		createDocumentTemplate(46, "Real SSN Access Request", 201);
		
		createDocumentTemplate(47, "Surgery Data Research Proposal", 202);
		createDocumentTemplate(48, "Surgery Variable Checklist(s)", 203);
		createDocumentTemplate(49, "National Surgery Office (NSO) Data Use Agreement", 204);
		createDocumentTemplate(50, "Review Summary", 205);

		
		DocumentTemplate dt = IDHash.get(4);
		dt.setLocation(true);
		dt.setAdministrator(true);
		dt.setParticipant(true);
		dt.setActivityType("activity type");
		
	}

}
